<?php
/**
 * Plugin Name: RCCC Logout & Redirect
 * Description: Adds an admin-bar action and a shortcode to log the current user out and redirect to a contractor login page (or any URL you choose).
 * Version: 1.0.0
 * Author: RCCC
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/* Default redirect URL after logout (relative or absolute). Change as needed. */
function rccc_default_logout_redirect_url() {
    return home_url( '/wp-login.php' );
}

/* Admin bar item: "Logout → Contractor Login" visible to administrators only */
add_action( 'admin_bar_menu', function( $wp_admin_bar ) {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    $default_url = apply_filters( 'rccc_logout_redirect_url', rccc_default_logout_redirect_url() );
    $logout_link  = wp_logout_url( esc_url_raw( $default_url ) );

    $wp_admin_bar->add_node( array(
        'id'    => 'rccc_logout_redirect',
        'title' => 'Logout → Contractor Login',
        'href'  => $logout_link,
        'meta'  => array(
            'title' => 'Log out and go to contractor login',
        ),
    ) );
}, 100 );

/* Shortcode: [rccc_logout_redirect url="/wp-login.php" label="Log out and go to contractor login"] */
add_shortcode( 'rccc_logout_redirect', function( $atts ) {
    $atts = shortcode_atts( array(
        'url'   => rccc_default_logout_redirect_url(),
        'label' => 'Log out and go to contractor login',
        'class' => 'rccc-logout-redirect-btn',
    ), $atts, 'rccc_logout_redirect' );

    $redirect = esc_url( $atts['url'] );
    $label    = esc_html( $atts['label'] );
    $class    = esc_attr( $atts['class'] );

    $logout_url = wp_logout_url( $redirect );

    return '<a href="' . esc_url( $logout_url ) . '" class="' . $class . '" style="display:inline-block;padding:8px 12px;background:#047857;color:#fff;border-radius:8px;text-decoration:none;">' . $label . '</a>';
} );

/* Simple inline CSS for the button */
add_action( 'wp_head', function() {
    if ( is_user_logged_in() ) {
        echo '<style>.rccc-logout-redirect-btn:hover{opacity:.92}</style>';
    }
} );